/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.generator.structuredefinition.intermediate;

import com.google.common.collect.ImmutableCollection;
import de.fhlintstone.accessors.implementations.ITypeSpecification;
import java.util.Optional;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Singular;

/**
 * Default implementation of {@link ITypeAttribute}.
 */
@EqualsAndHashCode
@Builder(setterPrefix = "with")
public final class TypeAttribute implements ITypeAttribute {

    @Getter
    private final String fhirName;

    @Getter
    private final String elementId;

    @Getter
    private final int min;

    @Getter
    private final int max;

    @Getter
    @Singular
    private final ImmutableCollection<ITypeSpecification> types;

    @Getter
    private final boolean extension;

    @Getter
    private final boolean modifier;

    @Getter
    @Builder.Default
    private final Optional<String> extensionUrl = Optional.empty();

    @Getter
    @Builder.Default
    private final Optional<String> definition = Optional.empty();

    @Getter
    @Builder.Default
    private final Optional<String> shortDefinition = Optional.empty();

    @Getter
    @Builder.Default
    private final Optional<String> bindingValueSet = Optional.empty();

    @Override
    public String toString() {
        return "TypeAttribute [fhirName=" + this.fhirName + ", definition=" + this.definition + "]";
    }
}
