/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.generator.structuredefinition.intermediate;

import de.fhlintstone.fhir.dependencies.IDependencyGraph;
import de.fhlintstone.fhir.dependencies.IDependencyNode;
import de.fhlintstone.generator.GeneratorException;
import de.fhlintstone.process.config.ProcessConfiguration;
import java.util.Optional;

/**
 * Component that takes a node of an {@link IDependencyGraph} and turns it into an instance of {@link ITypeInformation}s
 * to generate a class to represent the StructureDefinitions described by the node.
 */
public interface ITypeInformationBuilder {

    /**
     * Creates an {@link ITypeInformation} instance to generate the structure contained in a {@link IDependencyNode}.
     * May return an empty object if no type needs to be generated.
     *
     * @param configuration               the {@link ProcessConfiguration} to use
     * @param dependencyNode              the {@link IDependencyNode} representing the structure definition
     * @return the {@link ITypeInformation} corresponding to the node
     * @throws GeneratorException
     */
    Optional<ITypeInformation> buildTypeInformation(ProcessConfiguration configuration, IDependencyNode dependencyNode)
            throws GeneratorException;
}
