/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.generator.structuredefinition.code;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.experimental.SuperBuilder;

/**
 * Default implementation of {@link ITopLevelClass}.
 */
@EqualsAndHashCode(callSuper = true)
@SuperBuilder(setterPrefix = "with")
public final class TopLevelClass extends ClassData implements ITopLevelClass {

    @Getter
    private final String outputPath;

    @Getter
    private final Optional<String> description;

    private final List<INestedClass> nestedClassList = new ArrayList<>();

    @Override
    public ImmutableList<INestedClass> getNestedClasses() {
        return ImmutableList.copyOf(this.nestedClassList);
    }

    /**
     * Adds a nested class to the class.
     *
     * @param nestedClass the nestedClass to add
     */
    public void addNestedClass(INestedClass nestedClass) {
        this.nestedClassList.add(nestedClass);
    }
}
