/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.generator.structuredefinition.code;

import com.google.common.collect.ImmutableList;
import de.fhlintstone.generator.structuredefinition.IStructureDefinitionGenerator;
import java.util.Optional;

/**
 * The description of a top-level class transferred from the {@link IStructureDefinitionGenerator} to
 * the {@link ICodeEmitter}.
 */
public interface ITopLevelClass extends IClassData {

    /**
     * @return the path to write the class to
     */
    String getOutputPath();

    /**
     * @return the description of the StructureDefinition
     */
    Optional<String> getDescription();

    /**
     * @return the list of nested classes
     */
    ImmutableList<INestedClass> getNestedClasses();
}
