/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.generator.structuredefinition.code;

import com.google.common.collect.ImmutableList;
import com.palantir.javapoet.TypeName;

/**
 * An constructor of a generated class that is described by {@link IClassData}. Note that this structure is currently
 * only suitable to generate inherited constructors, i.e. constructors that only call the constructor of the superclass
 * with the same signature.
 */
public interface IClassConstructor {

    /**
     * Description of a parameter of the constructor.
     *
     * @param type the type of the parameter
     * @param name the name of the parameter
     */
    public record ConstructorParameter(TypeName type, String name) {}

    /**
     * Determines whether the constructor is marked as deprecated.
     *
     * @return <code>true</code> if the constructor is marked as deprecated
     */
    boolean isDeprecated();

    /**
     * Determines the parameters of the constructor.
     *
     * @return the parameters of the constructor
     */
    ImmutableList<ConstructorParameter> getParameters();
}
