/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.generator.structuredefinition.code;

import com.google.common.collect.ImmutableMap;
import com.palantir.javapoet.ClassName;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Singular;

/**
 * Default implementation of {@link IClassAttributeAnnotation}.
 */
@EqualsAndHashCode
@Builder(setterPrefix = "with")
public final class ClassAttributeAnnotation implements IClassAttributeAnnotation {

    @Getter
    private final ClassName annotation;

    @Getter
    @Singular
    private final ImmutableMap<String, Object> parameters;

    @Override
    public String toString() {
        return "ClassAttributeAnnotation [annotation=" + this.annotation + ", parameters=" + this.parameters + "]";
    }
}
