/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.generator.structuredefinition.code;

import ca.uhn.fhir.model.api.annotation.Child;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.palantir.javapoet.TypeName;
import de.fhlintstone.accessors.implementations.IMappedType;
import java.util.Optional;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Singular;

/**
 * Default implementation of {@link IClassAttribute}.
 */
@EqualsAndHashCode
@Builder(setterPrefix = "with")
public final class ClassAttribute implements IClassAttribute {

    @Getter
    private final String name;

    @Getter
    private final String fhirName;

    @Getter
    private final String elementId;

    @Getter
    private final Optional<String> extensionUrl;

    @Getter
    private final boolean extension;

    @Getter
    private final boolean modifierExtension;

    @Getter
    private final Optional<String> description;

    @Getter
    private final TypeName attributeType;

    @Getter
    private final TypeName actualType;

    @Getter
    private final TypeName creationType;

    @Getter
    @Singular
    private final ImmutableCollection<IMappedType> mappedTypes;

    @Getter
    @Singular
    private final ImmutableCollection<String> propertyTypes;

    @Getter
    @Builder.Default
    private final Optional<TypeName> primitiveType = Optional.empty();

    @Getter
    private final Optional<String> baseCastingMethod;

    @Getter
    private final AccessorGenerationMode accessorGenerationMode;

    @Getter
    private final int min;

    @Getter
    private final int max;

    @Getter
    private final boolean derivedFromPrimitiveType;

    @Getter
    @Builder.Default
    private final Optional<String> definition = Optional.empty();

    @Getter
    @Singular
    private final ImmutableList<IClassAttributeAnnotation> annotations;

    @Override
    public String toString() {
        return "ClassAttribute [name=" + this.name + ", element=" + this.elementId + ", attributeType="
                + this.attributeType + "]";
    }

    @Override
    public boolean isRepeating() {
        return (this.max > 1) || (this.max == Child.MAX_UNLIMITED);
    }

    @Override
    public boolean isMultiType() {
        return this.mappedTypes.size() > 1;
    }
}
