/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.generator.structuredefinition.code;

/**
 * This enum describes what kind of accessors need to be generated for an attribute.
 */
public enum AccessorGenerationMode {

    /**
     * For an attribute with this mode, generate
     * <ul>
     * <li>a getter returning the primitive type</li>
     * <li>a getter returning the element</li>
     * <li>an existence check without suffix</li>
     * <li>an existence check with the Element suffix (for consistency)</li>
     * <li>a setter for the primitive type</li>
     * <li>a setter for the entire element</li>
     * </ul>
     */
    SINGLE_TYPE_NON_REPEATING_PRIMITIVE,

    /**
     * For an attribute with this mode, generate
     * <ul>
     * <li>a getter returning the element</li>
     * <li>an existence check without suffix</li>
     * <li>a setter for the entire element</li>
     * </ul>
     */
    SINGLE_TYPE_NON_REPEATING_ELEMENT,

    /**
     * For an attribute with this mode, generate
     * <ul>
     * <li>an adder that creates a new element</li>
     * <li>an adder that takes an existing element</li>
     * <li>a getter returning the element list</li>
     * <li>a getter returning the first element of the list</li>
     * <li>an existence check without suffix</li>
     * <li>a setter for the entire element list</li>
     * </ul>
     */
    SINGLE_TYPE_REPEATING_PRIMITIVE,

    /**
     * For an attribute with this mode, generate
     * <ul>
     * <li>an adder that creates a new element</li>
     * <li>an adder that takes an existing element</li>
     * <li>a getter returning the element list</li>
     * <li>a getter returning the first element of the list</li>
     * <li>an existence check without suffix</li>
     * <li>a setter for the entire element list</li>
     * </ul>
     */
    SINGLE_TYPE_REPEATING_ELEMENT,

    /**
     * For an attribute with this mode, generate
     * <ul>
     * <li>getters returning the generic type and the supported types</li>
     * <li>an existence check without suffix for the generic type</li>
     * <li>existence checks for each of the types</li>
     * <li>setters for the generic and the supported types</li>
     * </ul>
     */
    MULTI_TYPE_NON_REPEATING,

    /**
     * For an attribute with this mode, generate
     * <ul>
     * <li>adders that create a new element</li>
     * <li>adders that takes an existing element</li>
     * <li>a getter returning the element list</li>
     * <li>an existence check without suffix</li>
     * <li>a setter for the entire element list</li>
     * </ul>
     */
    MULTI_TYPE_REPEATING
}
