/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.fhir.elements;

import de.fhlintstone.accessors.model.IStructureDefinitionAccessor;

/**
 * Examines the snapshot of a StructureDefinition and creates an
 * {@link IElementTree} that represents the structure of the ElementDefinitions.
 */
public interface IElementTreeBuilder {

    /**
     * Creates an {@link IElementTree} that represents the structure of the
     * ElementDefinitions, without using a base structure.
     *
     * @param structureDefinition the {@link IStructureDefinitionAccessor} to
     *                            examine
     * @return the {@link IElementTree} that represents the structure of the
     *         ElementDefinitions
     */
    IElementTree buildElementTree(IStructureDefinitionAccessor structureDefinition);

    /**
     * Creates an {@link IElementTree} that represents the structure of the
     * ElementDefinitions, including references to a base structure.
     *
     * @param structureDefinition the {@link IStructureDefinitionAccessor} to
     *                            examine
     * @param baseStructure       the {@link IStructureDefinitionAccessor} of the
     *                            base structure
     * @return the {@link IElementTree} that represents the structure of the
     *         ElementDefinitions
     */
    IElementTree buildElementTree(
            IStructureDefinitionAccessor structureDefinition, IStructureDefinitionAccessor baseStructure);
}
