/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.fhir.elements;

import de.fhlintstone.accessors.model.IElementDefinitionAccessor;
import de.fhlintstone.accessors.model.IStructureDefinitionAccessor;
import java.util.Optional;

/**
 * Provides access to the snapshot elements of a FHIR StructureDefinition,
 * organized as a tree structure.
 */
public interface IElementTree extends Iterable<IElementTreeNode> {

    /**
     * Returns the StructureDefinition accessor the element tree was built from.
     *
     * @return the StructureDefinition accessor the element tree was built from
     */
    IStructureDefinitionAccessor getStructureDefinition();

    /**
     * Returns the accessor for the StructureDefinition the "main" structure was
     * derived from.
     *
     * @return the accessor for the StructureDefinition the "main" structure was
     *         derived from
     */
    Optional<IStructureDefinitionAccessor> getBaseStructureDefinition();

    /**
     * Returns the root node of the element tree.
     *
     * @return the root node of the element tree
     */
    IElementTreeNode getRootNode();

    /**
     * Returns the node wrapping the element.
     *
     * @param element The element to get the node for
     * @return the node wrapping the element
     * @throws IllegalArgumentException if the element is not part of the tree
     *                                  structure
     */
    IElementTreeNode getNode(IElementDefinitionAccessor element) throws IllegalArgumentException;

    /**
     * Returns the tree node with the ID provided, if it exists.
     *
     * @param id The id of the node
     * @return the tree node with the ID provided, if it exists
     */
    Optional<IElementTreeNode> getNode(String id);
}
