/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.fhir.elements;

/**
 * Describes the relationship between an ElementDefinition in a
 * StructureDefinition (the "current structure") and the ElementDefinition with
 * the same ID in the base structure.
 */
public enum ElementBaseRelationship {

    /**
     * The element was added to the structure.
     *
     * The current structure is derived from a base structure; the snapshot of the
     * base structure does NOT contain an element with the same ID.
     */
    ADDED,

    /**
     * The element was changed in the structure.
     *
     * The current structure is derived from a base structure; both the snapshot of
     * the base structure and the differential of the current structure contain an
     * element with the same ID.
     */
    CHANGED,

    /**
     * The element remains unchanged in the structure.
     *
     * The current structure is derived from a base structure; both the the snapshot
     * of the base structure and the snapshot of the current structure contain an
     * element with the ID, but the differential of the current structure does not.
     */
    UNCHANGED,

    /**
     * The element tree was built without a base structure.
     *
     * The current structure either does not derive from a base structure or the
     * base structure was not provided when building the element tree.
     */
    NO_BASE
}
