/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.fhir.dependencies;

import com.palantir.javapoet.TypeName;
import de.fhlintstone.packages.FhirResourceType;
import java.net.URI;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBaseResource;

/**
 * A node in a dependency graph. A node is based on an {@link IBaseResource} and
 * carries some additional information required to process the dependency tree.
 */
public interface IDependencyNode {

    /**
     * Returns the URI identifying the resource.
     *
     * @return the URI identifying the resource
     */
    URI getResourceURI();

    /**
     * Returns the FHIR resource represented by the node, if it can be resolved.
     *
     * @return the FHIR resource represented by the node
     */
    Optional<IBaseResource> getResource();

    /**
     * Returns the {@link FhirResourceType} of the resource represented by the node,
     * if it can be resolved.
     *
     * @return the {@link FhirResourceType} of the resource represented by the node,
     *         if it can be resolved
     */
    Optional<FhirResourceType> getResourceType();

    /**
     * Returns the name of the HAPI FHIR type that implements the resource, if it
     * exists.
     *
     * @return the name of the HAPI FHIR type that implements the resource, if it
     *         exists
     */
    Optional<TypeName> getFrameworkType();
}
