/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.fhir.dependencies;

import java.net.URI;
import org.hl7.fhir.instance.model.api.IBaseResource;

/**
 * Utility to generate a {@link IDependencyGraph}.
 */
public interface IDependencyGraphBuilder {

    /**
     * Adds a resource to the base set from which the dependency graph is generated.
     *
     * @param resource The resource to be added
     * @throws DependencyException when the resource already has been added
     */
    void addResource(IBaseResource resource) throws DependencyException;

    /**
     * Determines whether the base set from which the dependency graph is generated already contains a resource with the
     * canonical URI provided.
     *
     * @param canonicalURI the URI to check for
     * @return <code>true</code> if the base set from which the dependency graph is generated already contains a
     *         resource with the canonical URI provided
     */
    boolean containsResource(URI canonicalURI);

    /**
     * Creates the dependency graph.
     *
     * @return the dependency graph
     * @throws DependencyException when the dependency graph could not be built
     */
    IDependencyGraph build() throws DependencyException;
}
