/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.fhir.dependencies;

import de.fhlintstone.fhir.dependencies.IDependency.Origin;

/**
 * This is the receiver interface to collect the dependencies that are determined when processing a resource.
 */
public interface IDependencyCollector {

    /**
     * Collects a dependency of the object currently being processed.
     * @param dependency the URL of the dependency
     * @param origin the {@link Origin} of the relationship
     * @throws DependencyException
     */
    void collect(String dependency, Origin origin) throws DependencyException;

    /**
     * Collects a dependency of the object currently being processed.
     * @param dependency the URL of the dependency
     * @param origin the {@link Origin} of the relationship
     * @param fallback see {@link IDependency#getFallback()}
     * @throws DependencyException
     */
    void collect(String dependency, Origin origin, String fallback) throws DependencyException;
}
