/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.fhir.dependencies;

import com.palantir.javapoet.TypeName;
import de.fhlintstone.packages.FhirResourceType;
import java.net.URI;
import java.util.Optional;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.hl7.fhir.instance.model.api.IBaseResource;

/**
 * Default implementation of {@link IDependencyNode}.
 */
@EqualsAndHashCode
@Builder(setterPrefix = "with")
public final class DependencyNode implements IDependencyNode {

    @Getter
    private final URI resourceURI;

    @Getter
    @Builder.Default
    private final Optional<IBaseResource> resource = Optional.empty();

    @Getter
    @Builder.Default
    private final Optional<FhirResourceType> resourceType = Optional.empty();

    @Getter
    @Builder.Default
    private final Optional<TypeName> frameworkType = Optional.empty();

    @Override
    public String toString() {
        if (this.frameworkType.isPresent()) {
            return "DependencyNode [resourceURI=" + this.resourceURI + ", frameworkType" + this.frameworkType.get()
                    + "]";
        } else {
            return "DependencyNode [resourceURI=" + this.resourceURI + "]";
        }
    }
}
