/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.fhir;

/**
 * Describes whether a StructureDefinition is an Extension and if it is, whether
 * it is a simple or a complex Extension.
 */
public enum ExtensionType {
    /**
     * The StructureDefinition is not an Extension.
     */
    NONE,

    /**
     * The StructureDefinition is a simple extension. Simple extensions have only a
     * value and no nested extensions.
     */
    SIMPLE,

    /**
     * The StructureDefinition is a complex extension. Complex extensions contain
     * one or more nested extensions and no value.
     */
    COMPLEX;
}
