/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.fhir;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.ResourceDef;

/**
 * Which of the HAPI annotations to place on the generated class.
 */
public enum ClassAnnotation {
    /**
     * Annotate the class with a {@link ResourceDef} annotation. The
     * <code>name</code> property is not set (according to the annotation
     * documentation). The <code>id</code> property is currently not set. The
     * <code>profile</code> property is set to the StructureDefinition URI.
     */
    RESOURCE,

    /**
     * Annotate the class with a {@link DatatypeDef} annotation. The
     * <code>name</code> property is set to the StructureDefinition name.
     *
     * TODO #4 determine whether and how to set isSpecialization and profileOf
     */
    DATATYPE,

    /**
     * Annotate the class with a {@link Block} annotation. No properties will be set
     * on the annotation.
     */
    BLOCK;
}
