/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import com.google.common.collect.ImmutableList;
import de.fhlintstone.accessors.IAccessorCache;
import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.hl7.fhir.r4b.model.ValueSet;
import org.hl7.fhir.r4b.model.ValueSet.ValueSetComposeComponent;

/**
 * Implementation of {@link IValueSetComposeComponentAccessor} for FHIR version
 * R4B. i.e. wrapping {@link ValueSet}.
 */
@EqualsAndHashCode(callSuper = true)
public final class ValueSetComposeComponentAccessorR4B extends BackboneElementAccessorR4B
        implements IValueSetComposeComponentAccessor {

    @Getter(AccessLevel.PRIVATE)
    private final ValueSetComposeComponent composeComponent;

    /**
     * Creates a new wrapper.
     *
     * @param cache the cache this accessor is managed by
     * @param composeComponent the {@link ValueSetComposeComponent} to wrap
     */
    public ValueSetComposeComponentAccessorR4B(IAccessorCache cache, ValueSetComposeComponent composeComponent) {
        super(cache, composeComponent);
        this.composeComponent = composeComponent;
    }

    @Override
    public ImmutableList<IConceptSetComponentAccessor> getInclude() {
        return this.composeComponent.getInclude().stream()
                .map(include -> getCache().getAccessor(include, IConceptSetComponentAccessor.class))
                .collect(ImmutableList.toImmutableList());
    }

    @Override
    public ImmutableList<IConceptSetComponentAccessor> getExclude() {
        return this.composeComponent.getExclude().stream()
                .map(exclude -> getCache().getAccessor(exclude, IConceptSetComponentAccessor.class))
                .collect(ImmutableList.toImmutableList());
    }
}
