/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import de.fhlintstone.accessors.IAccessorCache;
import lombok.EqualsAndHashCode;
import org.hl7.fhir.r5.model.UriType;

/**
 * Implementation of {@link IUriTypeAccessor} for FHIR release R5.
 */
@EqualsAndHashCode(callSuper = true)
public class UriTypeAccessorR5 extends PrimitiveTypeAccessorR5<String> implements IUriTypeAccessor {

    private final UriType uriType;

    /**
     * Creates a new wrapper.
     *
     * @param cache the cache this accessor is managed by
     * @param type the FHIR UriType to wrap
     */
    public UriTypeAccessorR5(IAccessorCache cache, UriType type) {
        super(cache, type);
        this.uriType = type;
    }
}
