/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import com.google.common.collect.ImmutableList;
import de.fhlintstone.accessors.IAccessorCache;
import lombok.EqualsAndHashCode;
import org.hl7.fhir.r4.model.StructureDefinition.StructureDefinitionSnapshotComponent;

/**
 * Implementation of {@link IStructureDefinitionSnapshotComponentAccessor} for
 * FHIR Release 4.
 */
@EqualsAndHashCode(callSuper = true)
public final class StructureDefinitionSnapshotComponentAccessorR4 extends BackboneElementAccessorR4
        implements IStructureDefinitionSnapshotComponentAccessor {

    private final StructureDefinitionSnapshotComponent snapshotComponent;

    /**
     * Creates a new wrapper.
     *
     * @param cache the cache this accessor is managed by
     * @param snapshotComponent the component to wrap
     */
    public StructureDefinitionSnapshotComponentAccessorR4(
            IAccessorCache cache, StructureDefinitionSnapshotComponent snapshotComponent) {
        super(cache, snapshotComponent);
        this.snapshotComponent = snapshotComponent;
    }

    @Override
    public ImmutableList<IElementDefinitionAccessor> getElement() {
        if (this.snapshotComponent.hasElement()) {
            return this.snapshotComponent.getElement().stream()
                    .map(element -> getCache().getAccessor(element, IElementDefinitionAccessor.class))
                    .collect(ImmutableList.toImmutableList());
        } else {
            return ImmutableList.of();
        }
    }
}
