/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import com.google.common.collect.ImmutableList;
import de.fhlintstone.accessors.IAccessorCache;
import lombok.EqualsAndHashCode;
import org.hl7.fhir.r4b.model.StructureDefinition.StructureDefinitionDifferentialComponent;

/**
 * Implementation of {@link IStructureDefinitionDifferentialComponentAccessor}
 * for FHIR Release R4B.
 */
@EqualsAndHashCode(callSuper = true)
public final class StructureDefinitionDifferentialComponentAccessorR4B extends BackboneElementAccessorR4B
        implements IStructureDefinitionDifferentialComponentAccessor {

    private final StructureDefinitionDifferentialComponent differentialComponent;

    /**
     * Creates a new wrapper.
     *
     * @param cache the cache this accessor is managed by
     * @param differentialComponent the component to wrap
     */
    public StructureDefinitionDifferentialComponentAccessorR4B(
            IAccessorCache cache, StructureDefinitionDifferentialComponent differentialComponent) {
        super(cache, differentialComponent);
        this.differentialComponent = differentialComponent;
    }

    @Override
    public ImmutableList<IElementDefinitionAccessor> getElement() {
        if (this.differentialComponent.hasElement()) {
            return this.differentialComponent.getElement().stream()
                    .map(element -> getCache().getAccessor(element, IElementDefinitionAccessor.class))
                    .collect(ImmutableList.toImmutableList());
        } else {
            return ImmutableList.of();
        }
    }
}
