/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;

/**
 * A string representation of a value of a generic typed attribute along with
 * information about the method of the actual implementation class that can be
 * used to transfer the value and whether to pass the value as a literal (42) or a
 * string ("42").
 */
@EqualsAndHashCode
@Builder(setterPrefix = "with")
public final class StringifiedValue {

    @Getter
    private final PrimitiveDatatype datatype;

    @Getter
    private final String value;

    @Getter
    private final String setterMethod;

    @Getter
    private final boolean literal;

    @Override
    public String toString() {
        return "StringifiedValue [datatype=" + this.datatype + ", value=" + this.value + "]";
    }
}
