/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import de.fhlintstone.accessors.IAccessorCache;
import java.util.Optional;
import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.hl7.fhir.r4b.model.Resource;

/**
 * Implementation of {@link IResourceAccessor} for FHIR release R4B.
 */
@EqualsAndHashCode(callSuper = true)
public class ResourceAccessorR4B extends BaseAccessorR4B implements IResourceAccessor {

    @Getter(AccessLevel.PRIVATE)
    private final Resource resource;

    /**
     * Creates a new wrapper.
     *
     * @param cache the cache this accessor is managed by
     * @param resource the FHIR Base to wrap
     */
    public ResourceAccessorR4B(IAccessorCache cache, Resource resource) {
        super(cache, resource);
        this.resource = resource;
    }

    @Override
    public Optional<String> getId() {
        if (this.resource.hasId()) {
            return Optional.of(this.resource.getId());
        } else {
            return Optional.empty();
        }
    }
}
