/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import de.fhlintstone.accessors.IAccessorCache;
import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.hl7.fhir.r5.model.MetadataResource;

/**
 * Implementation of {@link IMetadataResourceAccessor} for FHIR release R5.
 */
@EqualsAndHashCode(callSuper = true)
public class MetadataResourceAccessorR5 extends CanonicalResourceAccessorR5 implements IMetadataResourceAccessor {

    @Getter(AccessLevel.PRIVATE)
    private final MetadataResource metadataResource;

    /**
     * Creates a new wrapper.
     *
     * @param cache the cache this accessor is managed by
     * @param metadataResource the FHIR MetadataResource to wrap
     */
    public MetadataResourceAccessorR5(IAccessorCache cache, MetadataResource metadataResource) {
        super(cache, metadataResource);
        this.metadataResource = metadataResource;
    }
}
