/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import com.google.common.collect.ImmutableList;

/**
 * Release-independent wrapper for a FHIR ValueSet Compose Component.
 *
 * This interface and the corresponding implementations are used to make as
 * much of the rest of the core library release-independent, i.e. shield it
 * from the various HAPI FHIR release package differences.
 *
 * @see org.hl7.fhir.r4.model.ValueSet.ValueSetComposeComponent
 * @see org.hl7.fhir.r4b.model.ValueSet.ValueSetComposeComponent
 * @see org.hl7.fhir.r5.model.ValueSet.ValueSetComposeComponent
 */
public interface IValueSetComposeComponentAccessor extends IBackboneElementAccessor {

    /**
     * Returns the wrapped contents of the exclude section.
     *
     * @return the wrapped contents of the exclude section
     * @see org.hl7.fhir.r4.model.ValueSet.ValueSetComposeComponent#hasExclude()
     * @see org.hl7.fhir.r4.model.ValueSet.ValueSetComposeComponent#getExclude()
     * @see org.hl7.fhir.r4b.model.ValueSet.ValueSetComposeComponent#hasExclude()
     * @see org.hl7.fhir.r4b.model.ValueSet.ValueSetComposeComponent#getExclude()
     * @see org.hl7.fhir.r5.model.ValueSet.ValueSetComposeComponent#hasExclude()
     * @see org.hl7.fhir.r5.model.ValueSet.ValueSetComposeComponent#getExclude()
     */
    ImmutableList<IConceptSetComponentAccessor> getExclude();

    /**
     * Returns the wrapped contents of the include section.
     *
     * @return the wrapped contents of the include section
     * @see org.hl7.fhir.r4.model.ValueSet.ValueSetComposeComponent#hasInclude()
     * @see org.hl7.fhir.r4.model.ValueSet.ValueSetComposeComponent#getInclude()
     * @see org.hl7.fhir.r4b.model.ValueSet.ValueSetComposeComponent#hasInclude()
     * @see org.hl7.fhir.r4b.model.ValueSet.ValueSetComposeComponent#getInclude()
     * @see org.hl7.fhir.r5.model.ValueSet.ValueSetComposeComponent#hasInclude()
     * @see org.hl7.fhir.r5.model.ValueSet.ValueSetComposeComponent#getInclude()
     */
    ImmutableList<IConceptSetComponentAccessor> getInclude();
}
