/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import java.util.Optional;

/**
 * Release-independent wrapper for the HAPI FHIR general BaseResource and
 * Resource model types.
 *
 * This interface and the corresponding implementations are used to make as
 * much of the rest of the core library release-independent, i.e. shield it
 * from the various HAPI FHIR release package differences.
 *
 * @see org.hl7.fhir.r4.model.BaseResource
 * @see org.hl7.fhir.r4.model.Resource
 * @see org.hl7.fhir.r4b.model.BaseResource
 * @see org.hl7.fhir.r4b.model.Resource
 * @see org.hl7.fhir.r5.model.BaseResource
 * @see org.hl7.fhir.r5.model.Resource
 */
public interface IResourceAccessor extends IBaseAccessor {

    /**
     * Returns the ID of the Resource, if set.
     *
     * @return the ID of the Resource, if set
     * @see org.hl7.fhir.r4.model.Resource#hasId()
     * @see org.hl7.fhir.r4.model.Resource#getId()
     * @see org.hl7.fhir.r4b.model.Resource#hasId()
     * @see org.hl7.fhir.r4b.model.Resource#getId()
     * @see org.hl7.fhir.r5.model.Resource#hasId()
     * @see org.hl7.fhir.r5.model.Resource#getId()
     */
    Optional<String> getId();
}
