/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import com.google.common.collect.ImmutableList;
import java.util.Optional;

/**
 * Release-independent wrapper for a FHIR ElementDefinition.type instance.
 *
 * This interface and the corresponding implementations are used to make as much
 * of the rest of the core library release-independent, i.e. shield it from the
 * various HAPI FHIR release package differences.
 *
 * @see org.hl7.fhir.r4.model.ElementDefinition.TypeRefComponent
 * @see org.hl7.fhir.r4b.model.ElementDefinition.TypeRefComponent
 * @see org.hl7.fhir.r5.model.ElementDefinition.TypeRefComponent
 */
public interface IElementTypeRefComponentAccessor extends IElementAccessor {

    /**
     * Returns the type code of the ElementDefinition type reference, if set.
     *
     * This is the URL of the Data type or Resource that is a (or the) type used for
     * this element. References are URLs that are relative to
     * http://hl7.org/fhir/StructureDefinition, e.g. "string" is a reference to
     * http://hl7.org/fhir/StructureDefinition/string. Absolute URLs are only
     * allowed in logical models.
     *
     * According to the FHIR specification, the code element has a cardinality of
     * 1..1. To allow access to non-compliant structures that do not have a code
     * reference set, this method wraps the result into an {@link Optional}.
     *
     * @return the type code of the ElementDefinition type reference, if set
     * @see org.hl7.fhir.r4.model.ElementDefinition.TypeRefComponent#hasCode()
     * @see org.hl7.fhir.r4.model.ElementDefinition.TypeRefComponent#getCode()
     * @see org.hl7.fhir.r4b.model.ElementDefinition.TypeRefComponent#hasCode()
     * @see org.hl7.fhir.r4b.model.ElementDefinition.TypeRefComponent#getCode()
     * @see org.hl7.fhir.r5.model.ElementDefinition.TypeRefComponent#hasCode()
     * @see org.hl7.fhir.r5.model.ElementDefinition.TypeRefComponent#getCode()
     */
    Optional<String> getCode();

    /**
     * Returns the profiles of the ElementDefinition type reference, if set.
     *
     * This identifies a profile structure or implementation Guide that applies to
     * the data type this element refers to.
     *
     * If any profiles are specified, then the content must conform to at least one
     * of them. The URL can be a local reference - to a contained
     * StructureDefinition, or a reference to another StructureDefinition or
     * Implementation Guide by a canonical URL.
     *
     * When an implementation guide is specified, the type SHALL conform to at least
     * one profile defined in the implementation guide.
     *
     * @return the profiles of the ElementDefinition type reference, if set
     * @see org.hl7.fhir.r4.model.ElementDefinition.TypeRefComponent#hasProfile()
     * @see org.hl7.fhir.r4.model.ElementDefinition.TypeRefComponent#getProfile()
     * @see org.hl7.fhir.r4b.model.ElementDefinition.TypeRefComponent#hasProfile()
     * @see org.hl7.fhir.r4b.model.ElementDefinition.TypeRefComponent#getProfile()
     * @see org.hl7.fhir.r5.model.ElementDefinition.TypeRefComponent#hasProfile()
     * @see org.hl7.fhir.r5.model.ElementDefinition.TypeRefComponent#getProfile()
     */
    ImmutableList<ICanonicalTypeAccessor> getProfile();

    /**
     * Returns the target profiles of the ElementDefinition type reference, if set.
     *
     * This is used when the type is "Reference" or "canonical", and identifies a
     * profile structure or implementation Guide that applies to the target of the
     * reference this element refers to.
     *
     * If any profiles are specified, then the content must conform to at least one
     * of them. The URL can be a local reference - to a contained
     * StructureDefinition, or a reference to another StructureDefinition or
     * Implementation Guide by a canonical URL.
     *
     * When an implementation guide is specified, the target resource SHALL conform
     * to at least one profile defined in the implementation guide.
     *
     * @return the target profiles of the ElementDefinition type reference, if set
     * @see org.hl7.fhir.r4.model.ElementDefinition.TypeRefComponent#hasTargetProfile()
     * @see org.hl7.fhir.r4.model.ElementDefinition.TypeRefComponent#getTargetProfile()
     * @see org.hl7.fhir.r4b.model.ElementDefinition.TypeRefComponent#hasTargetProfile()
     * @see org.hl7.fhir.r4b.model.ElementDefinition.TypeRefComponent#getTargetProfile()
     * @see org.hl7.fhir.r5.model.ElementDefinition.TypeRefComponent#hasTargetProfile()
     * @see org.hl7.fhir.r5.model.ElementDefinition.TypeRefComponent#getTargetProfile()
     */
    ImmutableList<ICanonicalTypeAccessor> getTargetProfile();

    // not (yet) included: aggregation, versioning
}
