/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import java.util.Optional;

/**
 * Release-independent wrapper for a FHIR ElementDefinition.binding instance.
 *
 * This interface and the corresponding implementations are used to make as much
 * of the rest of the core library release-independent, i.e. shield it from the
 * various HAPI FHIR release package differences.
 *
 * @see org.hl7.fhir.r4.model.ElementDefinition.ElementDefinitionBindingComponent
 * @see org.hl7.fhir.r4b.model.ElementDefinition.ElementDefinitionBindingComponent
 * @see org.hl7.fhir.r5.model.ElementDefinition.ElementDefinitionBindingComponent
 */
public interface IElementDefinitionBindingComponentAccessor extends IElementAccessor {

    /**
     * Determines whether the binding is required.
     *
     * @return <code>true</code> if the binding strength is present and set to
     *         <code>required</code>; <code>false</code> if the binding strength is
     *         set to any other value, <code>empty</code> if the binding strength is
     *         not set.
     * @see org.hl7.fhir.r4.model.ElementDefinition.ElementDefinitionBindingComponent#hasStrength()
     * @see org.hl7.fhir.r4.model.ElementDefinition.ElementDefinitionBindingComponent#getStrength()
     * @see org.hl7.fhir.r4b.model.ElementDefinition.ElementDefinitionBindingComponent#hasStrength()
     * @see org.hl7.fhir.r4b.model.ElementDefinition.ElementDefinitionBindingComponent#getStrength()
     * @see org.hl7.fhir.r5.model.ElementDefinition.ElementDefinitionBindingComponent#hasStrength()
     * @see org.hl7.fhir.r5.model.ElementDefinition.ElementDefinitionBindingComponent#getStrength()
     * @deprecated use {@link #getStrength()} and evaluate locally
     */
    @Deprecated
    Optional<Boolean> isRequired();

    /**
     * Returns the strength of the binding, if set.
     *
     * @return the strength of the binding, if set
     * @see org.hl7.fhir.r4.model.ElementDefinition.ElementDefinitionBindingComponent#hasStrength()
     * @see org.hl7.fhir.r4.model.ElementDefinition.ElementDefinitionBindingComponent#getStrength()
     * @see org.hl7.fhir.r4b.model.ElementDefinition.ElementDefinitionBindingComponent#hasStrength()
     * @see org.hl7.fhir.r4b.model.ElementDefinition.ElementDefinitionBindingComponent#getStrength()
     * @see org.hl7.fhir.r5.model.ElementDefinition.ElementDefinitionBindingComponent#hasStrength()
     * @see org.hl7.fhir.r5.model.ElementDefinition.ElementDefinitionBindingComponent#getStrength()
     */
    Optional<BindingStrength> getStrength();

    /**
     * Returns the URL of the ValueSet.
     *
     * @return the URL of the ValueSet
     * @see org.hl7.fhir.r4.model.ElementDefinition.ElementDefinitionBindingComponent#hasValueSet()
     * @see org.hl7.fhir.r4.model.ElementDefinition.ElementDefinitionBindingComponent#getValueSet()
     * @see org.hl7.fhir.r4b.model.ElementDefinition.ElementDefinitionBindingComponent#hasValueSet()
     * @see org.hl7.fhir.r4b.model.ElementDefinition.ElementDefinitionBindingComponent#getValueSet()
     * @see org.hl7.fhir.r5.model.ElementDefinition.ElementDefinitionBindingComponent#hasValueSet()
     * @see org.hl7.fhir.r5.model.ElementDefinition.ElementDefinitionBindingComponent#getValueSet()
     */
    Optional<String> getValueSet();
}
