/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import com.google.common.collect.ImmutableList;
import java.util.Optional;

/**
 * Release-independent wrapper for a FHIR ElementDefinition.
 *
 * This interface and the corresponding implementations are used to make as much
 * of the rest of the core library release-independent, i.e. shield it from the
 * various HAPI FHIR release package differences.
 *
 * @see org.hl7.fhir.r4.model.ElementDefinition
 * @see org.hl7.fhir.r4b.model.ElementDefinition
 * @see org.hl7.fhir.r5.model.ElementDefinition
 */
public interface IElementDefinitionAccessor extends IBackboneTypeAccessor {

    /**
     * Returns the ID of the ElementDefinition, if set.
     *
     * @return the ID of the ElementDefinition, if set
     * @see org.hl7.fhir.r4.model.ElementDefinition#hasId()
     * @see org.hl7.fhir.r4.model.ElementDefinition#getId()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#hasId()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#getId()
     * @see org.hl7.fhir.r5.model.ElementDefinition#hasId()
     * @see org.hl7.fhir.r5.model.ElementDefinition#getId()
     */
    Optional<String> getId();

    /**
     * Returns the path of the ElementDefinition, if set.
     *
     * @return the path of the ElementDefinition, if set
     * @see org.hl7.fhir.r4.model.ElementDefinition#hasPath()
     * @see org.hl7.fhir.r4.model.ElementDefinition#getPath()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#hasPath()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#getPath()
     * @see org.hl7.fhir.r5.model.ElementDefinition#hasPath()
     * @see org.hl7.fhir.r5.model.ElementDefinition#getPath()
     */
    Optional<String> getPath();

    /**
     * Returns the minimum cardinality of the ElementDefinition, if set.
     *
     * @return the minimum cardinality of the ElementDefinition, if set
     * @see org.hl7.fhir.r4.model.ElementDefinition#hasMin()
     * @see org.hl7.fhir.r4.model.ElementDefinition#getMin()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#hasMin()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#getMin()
     * @see org.hl7.fhir.r5.model.ElementDefinition#hasMin()
     * @see org.hl7.fhir.r5.model.ElementDefinition#getMin()
     */
    Optional<Integer> getMin();

    /**
     * Returns the maximum cardinality of the ElementDefinition, if set.
     *
     * @return the maximum cardinality of the ElementDefinition, if set
     * @see org.hl7.fhir.r4.model.ElementDefinition#hasMax()
     * @see org.hl7.fhir.r4.model.ElementDefinition#getMax()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#hasMax()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#getMax()
     * @see org.hl7.fhir.r5.model.ElementDefinition#hasMax()
     * @see org.hl7.fhir.r5.model.ElementDefinition#getMax()
     */
    Optional<String> getMax();

    /**
     * Returns the definition of the ElementDefinition, if set.
     *
     * @return the definition of the ElementDefinition, if set
     * @see org.hl7.fhir.r4.model.ElementDefinition#hasDefinition()
     * @see org.hl7.fhir.r4.model.ElementDefinition#getDefinition()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#hasDefinition()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#getDefinition()
     * @see org.hl7.fhir.r5.model.ElementDefinition#hasDefinition()
     * @see org.hl7.fhir.r5.model.ElementDefinition#getDefinition()
     */
    Optional<String> getDefinition();

    /**
     * Returns the short definition of the ElementDefinition, if set.
     *
     * @return the short definition of the ElementDefinition, if set
     * @see org.hl7.fhir.r4.model.ElementDefinition#hasShort()
     * @see org.hl7.fhir.r4.model.ElementDefinition#getShort()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#hasShort()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#getShort()
     * @see org.hl7.fhir.r5.model.ElementDefinition#hasShort()
     * @see org.hl7.fhir.r5.model.ElementDefinition#getShort()
     */
    Optional<String> getShort();

    /**
     * Returns the fixed value of the ElementDefinition, if set.
     *
     * @return the fixed value of the ElementDefinition, if set
     * @see org.hl7.fhir.r4.model.ElementDefinition#hasFixed()
     * @see org.hl7.fhir.r4.model.ElementDefinition#getFixed()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#hasFixed()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#getFixed()
     * @see org.hl7.fhir.r5.model.ElementDefinition#hasFixed()
     * @see org.hl7.fhir.r5.model.ElementDefinition#getFixed()
     */
    Optional<ITypeAccessor> getFixed();

    /**
     * Returns the pattern value of the ElementDefinition, if set.
     *
     * @return the pattern value of the ElementDefinition, if set
     * @see org.hl7.fhir.r4.model.ElementDefinition#hasPattern()
     * @see org.hl7.fhir.r4.model.ElementDefinition#getPattern()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#hasPattern()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#getPattern()
     * @see org.hl7.fhir.r5.model.ElementDefinition#hasPattern()
     * @see org.hl7.fhir.r5.model.ElementDefinition#getPattern()
     */
    Optional<ITypeAccessor> getPattern();

    /**
     * Returns the short definition of the ElementDefinition, if set.
     *
     * @return the short definition of the ElementDefinition, if set
     * @see org.hl7.fhir.r4.model.ElementDefinition#hasBinding()
     * @see org.hl7.fhir.r4.model.ElementDefinition#getBinding()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#hasBinding()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#getBinding()
     * @see org.hl7.fhir.r5.model.ElementDefinition#hasBinding()
     * @see org.hl7.fhir.r5.model.ElementDefinition#getBinding()
     */
    Optional<IElementDefinitionBindingComponentAccessor> getBinding();

    /**
     * Returns the type information of the ElementDefinition, if set.
     *
     * @return the type information of the ElementDefinition, if set
     * @see org.hl7.fhir.r4.model.ElementDefinition#hasType()
     * @see org.hl7.fhir.r4.model.ElementDefinition#getType()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#hasType()
     * @see org.hl7.fhir.r4b.model.ElementDefinition#getType()
     * @see org.hl7.fhir.r5.model.ElementDefinition#hasType()
     * @see org.hl7.fhir.r5.model.ElementDefinition#getType()
     */
    ImmutableList<IElementTypeRefComponentAccessor> getType();
}
