/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import java.util.Optional;

/**
 * Release-independent wrapper for a FHIR ValueSet Concept Set Filter Component.
 *
 * This interface and the corresponding implementations are used to make as much
 * of the rest of the core library release-independent, i.e. shield it from the
 * various HAPI FHIR release package differences.
 *
 * @see org.hl7.fhir.r4.model.ValueSet.ConceptSetFilterComponent
 * @see org.hl7.fhir.r4b.model.ValueSet.ConceptSetFilterComponent
 * @see org.hl7.fhir.r5.model.ValueSet.ConceptSetFilterComponent
 */
public interface IConceptSetFilterComponentAccessor extends IBackboneElementAccessor {

    /**
     * Returns the filter operator, if set.
     *
     * @return the filter operator, if set
     * @see org.hl7.fhir.r4.model.ValueSet.ConceptSetFilterComponent#hasOp()
     * @see org.hl7.fhir.r4.model.ValueSet.ConceptSetFilterComponent#getOp()
     * @see org.hl7.fhir.r4b.model.ValueSet.ConceptSetFilterComponent#hasOp()
     * @see org.hl7.fhir.r4b.model.ValueSet.ConceptSetFilterComponent#getOp()
     * @see org.hl7.fhir.r5.model.ValueSet.ConceptSetFilterComponent#hasOp()
     * @see org.hl7.fhir.r5.model.ValueSet.ConceptSetFilterComponent#getOp()
     */
    Optional<FilterOperator> getOp();

    /**
     * Returns the property that is filtered on, if set.
     *
     * @return the property that is filtered on, if set
     * @see org.hl7.fhir.r4.model.ValueSet.ConceptSetFilterComponent#hasProperty()
     * @see org.hl7.fhir.r4.model.ValueSet.ConceptSetFilterComponent#getProperty()
     * @see org.hl7.fhir.r4b.model.ValueSet.ConceptSetFilterComponent#hasProperty()
     * @see org.hl7.fhir.r4b.model.ValueSet.ConceptSetFilterComponent#getProperty()
     * @see org.hl7.fhir.r5.model.ValueSet.ConceptSetFilterComponent#hasProperty()
     * @see org.hl7.fhir.r5.model.ValueSet.ConceptSetFilterComponent#getProperty()
     */
    Optional<String> getProperty();

    /**
     * Returns the filter value to evaluate, if set.
     *
     * @return the filter value to evaluate, if set
     * @see org.hl7.fhir.r4.model.ValueSet.ConceptSetFilterComponent#hasValue()
     * @see org.hl7.fhir.r4.model.ValueSet.ConceptSetFilterComponent#getValue()
     * @see org.hl7.fhir.r4b.model.ValueSet.ConceptSetFilterComponent#hasValue()
     * @see org.hl7.fhir.r4b.model.ValueSet.ConceptSetFilterComponent#getValue()
     * @see org.hl7.fhir.r5.model.ValueSet.ConceptSetFilterComponent#hasValue()
     * @see org.hl7.fhir.r5.model.ValueSet.ConceptSetFilterComponent#getValue()
     */
    Optional<String> getValue();
}
