/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import com.google.common.collect.ImmutableList;
import java.util.Optional;

/**
 * Release-independent wrapper for a FHIR ValueSet Concept Set Component.
 *
 * This interface and the corresponding implementations are used to make as much
 * of the rest of the core library release-independent, i.e. shield it from the
 * various HAPI FHIR release package differences.
 *
 * @see org.hl7.fhir.r4.model.ValueSet.ConceptSetComponent
 * @see org.hl7.fhir.r4b.model.ValueSet.ConceptSetComponent
 * @see org.hl7.fhir.r5.model.ValueSet.ConceptSetComponent
 */
public interface IConceptSetComponentAccessor extends IBackboneElementAccessor {

    /**
     * Returns the system of the concept set, if set.
     *
     * @return the system of the concept set, if set
     * @see org.hl7.fhir.r4.model.ValueSet.ConceptSetComponent#hasSystem()
     * @see org.hl7.fhir.r4.model.ValueSet.ConceptSetComponent#getSystem()
     * @see org.hl7.fhir.r4b.model.ValueSet.ConceptSetComponent#hasSystem()
     * @see org.hl7.fhir.r4b.model.ValueSet.ConceptSetComponent#getSystem()
     * @see org.hl7.fhir.r5.model.ValueSet.ConceptSetComponent#hasSystem()
     * @see org.hl7.fhir.r5.model.ValueSet.ConceptSetComponent#getSystem()
     */
    Optional<String> getSystem();

    /**
     * Returns the ValueSets of the concept set, if present.
     *
     * @return the ValueSets of the concept set, if present
     * @see org.hl7.fhir.r4.model.ValueSet.ConceptSetComponent#hasValueSet()
     * @see org.hl7.fhir.r4.model.ValueSet.ConceptSetComponent#getValueSet()
     * @see org.hl7.fhir.r4b.model.ValueSet.ConceptSetComponent#hasValueSet()
     * @see org.hl7.fhir.r4b.model.ValueSet.ConceptSetComponent#getValueSet()
     * @see org.hl7.fhir.r5.model.ValueSet.ConceptSetComponent#hasValueSet()
     * @see org.hl7.fhir.r5.model.ValueSet.ConceptSetComponent#getValueSet()
     */
    ImmutableList<ICanonicalTypeAccessor> getValueSet();

    /**
     * Returns the filters of the concept set, if present.
     *
     * @return the filters of the concept set, if present
     * @see org.hl7.fhir.r4.model.ValueSet.ConceptSetComponent#hasFilter()
     * @see org.hl7.fhir.r4.model.ValueSet.ConceptSetComponent#getFilter()
     * @see org.hl7.fhir.r4b.model.ValueSet.ConceptSetComponent#hasFilter()
     * @see org.hl7.fhir.r4b.model.ValueSet.ConceptSetComponent#getFilter()
     * @see org.hl7.fhir.r5.model.ValueSet.ConceptSetComponent#hasFilter()
     * @see org.hl7.fhir.r5.model.ValueSet.ConceptSetComponent#getFilter()
     */
    ImmutableList<IConceptSetFilterComponentAccessor> getFilter();

    /**
     * Returns the concepts of the concept set, if present.
     *
     * @return the concepts of the concept set, if present
     * @see org.hl7.fhir.r4.model.ValueSet.ConceptSetComponent#hasConcept()
     * @see org.hl7.fhir.r4.model.ValueSet.ConceptSetComponent#getConcept()
     * @see org.hl7.fhir.r4b.model.ValueSet.ConceptSetComponent#hasConcept()
     * @see org.hl7.fhir.r4b.model.ValueSet.ConceptSetComponent#getConcept()
     * @see org.hl7.fhir.r5.model.ValueSet.ConceptSetComponent#hasConcept()
     * @see org.hl7.fhir.r5.model.ValueSet.ConceptSetComponent#getConcept()
     */
    ImmutableList<IConceptReferenceComponentAccessor> getConcept();
}
