/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import java.util.Optional;

/**
 * Release-independent wrapper for a FHIR ValueSet Reference Component.
 *
 * This interface and the corresponding implementations are used to make as much
 * of the rest of the core library release-independent, i.e. shield it from the
 * various HAPI FHIR release package differences.
 *
 * @see org.hl7.fhir.r4.model.ValueSet.ConceptReferenceComponent
 * @see org.hl7.fhir.r4b.model.ValueSet.ConceptReferenceComponent
 * @see org.hl7.fhir.r5.model.ValueSet.ConceptReferenceComponent
 */
public interface IConceptReferenceComponentAccessor extends IBackboneElementAccessor {

    /**
     * Returns the display string of the concept, if set.
     *
     * @return the display string of the concept, if set
     * @see org.hl7.fhir.r4.model.ValueSet.ConceptReferenceComponent#hasDisplay()
     * @see org.hl7.fhir.r4.model.ValueSet.ConceptReferenceComponent#getDisplay()
     * @see org.hl7.fhir.r4b.model.ValueSet.ConceptReferenceComponent#hasDisplay()
     * @see org.hl7.fhir.r4b.model.ValueSet.ConceptReferenceComponent#getDisplay()
     * @see org.hl7.fhir.r5.model.ValueSet.ConceptReferenceComponent#hasDisplay()
     * @see org.hl7.fhir.r5.model.ValueSet.ConceptReferenceComponent#getDisplay()
     */
    Optional<String> getDisplay();

    /**
     * Returns the code of the concept, if set.
     *
     * @return the code of the concept, if set
     * @see org.hl7.fhir.r4.model.ValueSet.ConceptReferenceComponent#hasCode()
     * @see org.hl7.fhir.r4.model.ValueSet.ConceptReferenceComponent#getCode()
     * @see org.hl7.fhir.r4b.model.ValueSet.ConceptReferenceComponent#hasCode()
     * @see org.hl7.fhir.r4b.model.ValueSet.ConceptReferenceComponent#getCode()
     * @see org.hl7.fhir.r5.model.ValueSet.ConceptReferenceComponent#hasCode()
     * @see org.hl7.fhir.r5.model.ValueSet.ConceptReferenceComponent#getCode()
     */
    Optional<String> getCode();
}
