/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import java.util.Optional;

/**
 * Release-independent wrapper for a canonical type reference property used in a FHIR
 * CodeSystem concept.
 *
 * This interface and the corresponding implementations are used to make as
 * much of the rest of the core library release-independent, i.e. shield it
 * from the various HAPI FHIR release package differences.
 *
 * @see org.hl7.fhir.r4.model.CodeSystem.ConceptPropertyComponent
 * @see org.hl7.fhir.r4b.model.CodeSystem.ConceptPropertyComponent
 * @see org.hl7.fhir.r5.model.CodeSystem.ConceptPropertyComponent
 */
public interface IConceptPropertyComponentAccessor extends IBackboneElementAccessor {

    /**
     * A code that is a reference to CodeSystem.property.code.
     * @return the code of the property, if set
     * @see org.hl7.fhir.r4.model.CodeSystem.ConceptPropertyComponent#hasCode()
     * @see org.hl7.fhir.r4.model.CodeSystem.ConceptPropertyComponent#getCode()
     * @see org.hl7.fhir.r4b.model.CodeSystem.ConceptPropertyComponent#hasCode()
     * @see org.hl7.fhir.r4b.model.CodeSystem.ConceptPropertyComponent#getCode()
     * @see org.hl7.fhir.r5.model.CodeSystem.ConceptPropertyComponent#hasCode()
     * @see org.hl7.fhir.r5.model.CodeSystem.ConceptPropertyComponent#getCode()
     */
    Optional<String> getCode();

    /**
     * The value of this property.
     * @return the value of the property, if set
     * @see org.hl7.fhir.r4.model.CodeSystem.ConceptPropertyComponent#hasValue()
     * @see org.hl7.fhir.r4.model.CodeSystem.ConceptPropertyComponent#getValue()
     * @see org.hl7.fhir.r4b.model.CodeSystem.ConceptPropertyComponent#hasValue()
     * @see org.hl7.fhir.r4b.model.CodeSystem.ConceptPropertyComponent#getValue()
     * @see org.hl7.fhir.r5.model.CodeSystem.ConceptPropertyComponent#hasValue()
     * @see org.hl7.fhir.r5.model.CodeSystem.ConceptPropertyComponent#getValue()
     */
    Optional<ITypeAccessor> getValue();
}
