/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import com.google.common.collect.ImmutableList;
import java.util.Optional;

/**
 * Release-independent wrapper for a canonical type reference used in a FHIR
 * CodeSystem concept.
 *
 * This interface and the corresponding implementations are used to make as
 * much of the rest of the core library release-independent, i.e. shield it
 * from the various HAPI FHIR release package differences.
 *
 * @see org.hl7.fhir.r4.model.CodeSystem.ConceptDefinitionComponent
 * @see org.hl7.fhir.r4b.model.CodeSystem.ConceptDefinitionComponent
 * @see org.hl7.fhir.r5.model.CodeSystem.ConceptDefinitionComponent
 */
public interface IConceptDefinitionComponentAccessor extends IBackboneElementAccessor {

    /**
     * A human readable string that is the recommended default way to present this concept to a user.
     * @return the display string of the concept, if set
     * @see org.hl7.fhir.r4.model.CodeSystem.ConceptDefinitionComponent#hasDisplay()
     * @see org.hl7.fhir.r4.model.CodeSystem.ConceptDefinitionComponent#getDisplay()
     * @see org.hl7.fhir.r4b.model.CodeSystem.ConceptDefinitionComponent#hasDisplay()
     * @see org.hl7.fhir.r4b.model.CodeSystem.ConceptDefinitionComponent#getDisplay()
     * @see org.hl7.fhir.r5.model.CodeSystem.ConceptDefinitionComponent#hasDisplay()
     * @see org.hl7.fhir.r5.model.CodeSystem.ConceptDefinitionComponent#getDisplay()
     */
    Optional<String> getDisplay();

    /**
     * A code - a text symbol - that uniquely identifies the concept within the code system.
     * @return the code of the concept, if set
     * @see org.hl7.fhir.r4.model.CodeSystem.ConceptDefinitionComponent#hasCode()
     * @see org.hl7.fhir.r4.model.CodeSystem.ConceptDefinitionComponent#getCode()
     * @see org.hl7.fhir.r4b.model.CodeSystem.ConceptDefinitionComponent#hasCode()
     * @see org.hl7.fhir.r4b.model.CodeSystem.ConceptDefinitionComponent#getCode()
     * @see org.hl7.fhir.r5.model.CodeSystem.ConceptDefinitionComponent#hasCode()
     * @see org.hl7.fhir.r5.model.CodeSystem.ConceptDefinitionComponent#getCode()
     */
    Optional<String> getCode();

    /**
     * List of Property value for the concept.
     * @return the properties of the concept, if any
     * @see org.hl7.fhir.r4.model.CodeSystem.ConceptDefinitionComponent#getProperty()
     * @see org.hl7.fhir.r4b.model.CodeSystem.ConceptDefinitionComponent#getProperty()
     * @see org.hl7.fhir.r5.model.CodeSystem.ConceptDefinitionComponent#getProperty()
     */
    ImmutableList<IConceptPropertyComponentAccessor> getProperty();

    /**
     * Returns the list of child concepts of the code system concept.
     * @return the child concepts of the concept, if any
     * @see org.hl7.fhir.r4.model.CodeSystem.ConceptDefinitionComponent#getConcept()
     * @see org.hl7.fhir.r4b.model.CodeSystem.ConceptDefinitionComponent#getConcept()
     * @see org.hl7.fhir.r5.model.CodeSystem.ConceptDefinitionComponent#getConcept()
     */
    ImmutableList<IConceptDefinitionComponentAccessor> getChildConcept();
}
