/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import com.google.common.collect.ImmutableList;
import de.fhlintstone.accessors.IAccessor;
import java.util.Optional;

/**
 * Release-independent wrapper for the HAPI FHIR general Base model type.
 *
 * This interface and the corresponding implementations are used to make as much
 * of the rest of the core library release-independent, i.e. shield it from the
 * various HAPI FHIR release package differences.
 *
 * @see org.hl7.fhir.r4.model.Base
 * @see org.hl7.fhir.r4b.model.Base
 * @see org.hl7.fhir.r5.model.Base
 */
public interface IBaseAccessor extends IAccessor {

    /**
     * Determines the ID of the model element, if possible.
     * @return the ID of the model element
     * @see org.hl7.fhir.r4.model.Base#getIdBase()
     * @see org.hl7.fhir.r4b.model.Base#getIdBase()
     * @see org.hl7.fhir.r5.model.Base#getIdBase()
     */
    Optional<String> getId();

    /**
     * Determines the FHIR type of the model element, if available.
     * @return the FHIR type of the model element
     * @see org.hl7.fhir.r4.model.Base#fhirType()
     * @see org.hl7.fhir.r4b.model.Base#fhirType()
     * @see org.hl7.fhir.r5.model.Base#fhirType()
     */
    Optional<String> getFhirType();

    /**
     * Determines the list of children of the object.
     * @return the list of children of the object
     */
    ImmutableList<IPropertyAccessor> children();

    /**
     * Returns a child with the name specified, if it exists.
     * @param name the name to search for
     * @return a child with the name specified, if it exists
     */
    Optional<IPropertyAccessor> getChildByName(String name);
}
