/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import de.fhlintstone.accessors.IAccessorCache;
import lombok.EqualsAndHashCode;
import org.hl7.fhir.r4.model.Extension;

/**
 * Implementation of {@link IExtensionAccessor} for FHIR Release R4.
 */
@EqualsAndHashCode(callSuper = true)
public final class ExtensionAccessorR4 extends TypeAccessorR4 implements IExtensionAccessor {

    private final Extension extension;

    /**
     * Default constructor
     *
     * @param cache the cache this accessor is managed by
     * @param extension the {@link Extension} to wrap
     */
    public ExtensionAccessorR4(IAccessorCache cache, Extension extension) {
        super(cache, extension);
        this.extension = extension;
    }
}
