/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import com.google.common.collect.ImmutableList;
import de.fhlintstone.accessors.IAccessorCache;
import java.util.Optional;
import lombok.EqualsAndHashCode;
import org.hl7.fhir.r5.model.ElementDefinition.TypeRefComponent;

/**
 * Implementation of {@link IElementTypeRefComponentAccessor} for FHIR Release
 * R5.
 */
@EqualsAndHashCode(callSuper = true)
public final class ElementTypeRefComponentAccessorR5 extends ElementAccessorR5
        implements IElementTypeRefComponentAccessor {

    private final TypeRefComponent typeRefComponent;

    /**
     * Creates a new wrapper.
     *
     * @param cache the cache this accessor is managed by
     * @param typeRefComponent the TypeRefComponent instance to wrap
     */
    public ElementTypeRefComponentAccessorR5(IAccessorCache cache, TypeRefComponent typeRefComponent) {
        super(cache, typeRefComponent);
        this.typeRefComponent = typeRefComponent;
    }

    @Override
    public Optional<String> getCode() {
        if (this.typeRefComponent.hasCode()) {
            return Optional.of(this.typeRefComponent.getCode());
        } else {
            return Optional.empty();
        }
    }

    @Override
    public ImmutableList<ICanonicalTypeAccessor> getProfile() {
        if (this.typeRefComponent.hasProfile()) {
            return ImmutableList.copyOf(this.typeRefComponent.getProfile().stream()
                    .map(profile -> getCache().getAccessor(profile, ICanonicalTypeAccessor.class))
                    .toList());
        } else {
            return ImmutableList.of();
        }
    }

    @Override
    public ImmutableList<ICanonicalTypeAccessor> getTargetProfile() {
        if (this.typeRefComponent.hasTargetProfile()) {
            return ImmutableList.copyOf(this.typeRefComponent.getTargetProfile().stream()
                    .map(profile -> getCache().getAccessor(profile, ICanonicalTypeAccessor.class))
                    .toList());
        } else {
            return ImmutableList.of();
        }
    }
}
