/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import de.fhlintstone.accessors.IAccessorCache;
import java.util.Optional;
import lombok.EqualsAndHashCode;
import org.hl7.fhir.r5.model.ElementDefinition.ElementDefinitionBindingComponent;

/**
 * Implementation of {@link IElementDefinitionBindingComponentAccessor} for FHIR
 * Release R5.
 */
@EqualsAndHashCode(callSuper = true)
public final class ElementDefinitionBindingComponentAccessorR5 extends ElementAccessorR5
        implements IElementDefinitionBindingComponentAccessor {

    private final ElementDefinitionBindingComponent bindingComponent;

    /**
     * Creates a new wrapper.
     *
     * @param cache the cache this accessor is managed by
     * @param bindingComponent the ElementDefinitionBindingComponent instance to wrap
     */
    public ElementDefinitionBindingComponentAccessorR5(
            IAccessorCache cache, ElementDefinitionBindingComponent bindingComponent) {
        super(cache, bindingComponent);
        this.bindingComponent = bindingComponent;
    }

    @Override
    public Optional<Boolean> isRequired() {
        if (this.bindingComponent.hasStrength()) {
            return Optional.of(
                    this.bindingComponent.getStrength() == org.hl7.fhir.r5.model.Enumerations.BindingStrength.REQUIRED);
        } else {
            return Optional.empty();
        }
    }

    @Override
    public Optional<BindingStrength> getStrength() {
        if (this.bindingComponent.hasStrength()) {
            switch (this.bindingComponent.getStrength()) {
                case EXAMPLE:
                    return Optional.of(BindingStrength.EXAMPLE);
                case EXTENSIBLE:
                    return Optional.of(BindingStrength.EXTENSIBLE);
                case PREFERRED:
                    return Optional.of(BindingStrength.PREFERRED);
                case REQUIRED:
                    return Optional.of(BindingStrength.REQUIRED);
                default:
                    return Optional.empty();
            }
        } else {
            return Optional.empty();
        }
    }

    @Override
    public Optional<String> getValueSet() {
        if (this.bindingComponent.hasValueSet()) {
            return Optional.of(this.bindingComponent.getValueSet());
        } else {
            return Optional.empty();
        }
    }
}
