/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import de.fhlintstone.accessors.IAccessorCache;
import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.hl7.fhir.r4b.model.DomainResource;

/**
 * Implementation of {@link IDomainResourceAccessor} for FHIR release R4B.
 */
@EqualsAndHashCode(callSuper = true)
public class DomainResourceAccessorR4B extends ResourceAccessorR4B implements IDomainResourceAccessor {

    @Getter(AccessLevel.PRIVATE)
    private final DomainResource domainResource;

    /**
     * Creates a new wrapper.
     *
     * @param cache the cache this accessor is managed by
     * @param resource the FHIR DomainResource to wrap
     */
    public DomainResourceAccessorR4B(IAccessorCache cache, DomainResource resource) {
        super(cache, resource);
        this.domainResource = resource;
    }
}
