/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import de.fhlintstone.accessors.IAccessorCache;
import java.util.Optional;
import lombok.EqualsAndHashCode;
import org.hl7.fhir.r4.model.ValueSet.ConceptReferenceComponent;

/**
 * Implementation of {@link IConceptReferenceComponentAccessor} for FHIR version
 * R4. i.e. wrapping {@link ConceptReferenceComponent}.
 */
@EqualsAndHashCode(callSuper = true)
public final class ConceptReferenceComponentAccessorR4 extends BackboneElementAccessorR4
        implements IConceptReferenceComponentAccessor {

    private final ConceptReferenceComponent component;

    /**
     * Creates a new wrapper.
     *
     * @param cache the cache this accessor is managed by
     * @param component the {@link ConceptReferenceComponent} to wrap
     */
    public ConceptReferenceComponentAccessorR4(IAccessorCache cache, ConceptReferenceComponent component) {
        super(cache, component);
        this.component = component;
    }

    @Override
    public Optional<String> getCode() {
        if (this.component.hasCode()) {
            return Optional.of(this.component.getCode());
        } else {
            return Optional.empty();
        }
    }

    @Override
    public Optional<String> getDisplay() {
        if (this.component.hasDisplay()) {
            return Optional.of(this.component.getDisplay());
        } else {
            return Optional.empty();
        }
    }
}
