/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import de.fhlintstone.accessors.IAccessorCache;
import java.util.Optional;
import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.hl7.fhir.r4b.model.CodeSystem.ConceptPropertyComponent;

/**
 * Implementation of {@link IConceptPropertyComponentAccessor} for FHIR
 * version R4B. i.e. wrapping {@link ConceptPropertyComponent}.
 */
@EqualsAndHashCode(callSuper = true)
public final class ConceptPropertyComponentAccessorR4B extends BackboneElementAccessorR4B
        implements IConceptPropertyComponentAccessor {

    @Getter(AccessLevel.PRIVATE)
    private final ConceptPropertyComponent property;

    /**
     * Creates a new wrapper.
     *
     * @param cache the cache this accessor is managed by
     * @param property the property to wrap
     */
    public ConceptPropertyComponentAccessorR4B(IAccessorCache cache, ConceptPropertyComponent property) {
        super(cache, property);
        this.property = property;
    }

    @Override
    public Optional<String> getCode() {
        if (this.property.hasCode()) {
            return Optional.of(this.property.getCode());
        } else {
            return Optional.empty();
        }
    }

    @Override
    public Optional<ITypeAccessor> getValue() {
        if (this.property.hasValue()) {
            return Optional.of(getCache().getAccessor(this.property.getValue(), ITypeAccessor.class));
        } else {
            return Optional.empty();
        }
    }
}
