/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import de.fhlintstone.accessors.IAccessorCache;
import java.util.Optional;
import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.hl7.fhir.r4b.model.CanonicalType;

/**
 * Implementation of {@link ICanonicalTypeAccessor} for FHIR version R4B. i.e.
 * wrapping {@link CanonicalType}.
 */
@EqualsAndHashCode(callSuper = true)
public final class CanonicalTypeAccessorR4B extends UriTypeAccessorR4B implements ICanonicalTypeAccessor {

    @Getter(AccessLevel.PRIVATE)
    private final CanonicalType canonicalType;

    /**
     * Creates a new wrapper.
     *
     * @param cache the cache this accessor is managed by
     * @param canonicalType the {@link CanonicalType} to wrap
     */
    public CanonicalTypeAccessorR4B(IAccessorCache cache, CanonicalType canonicalType) {
        super(cache, canonicalType);
        this.canonicalType = canonicalType;
    }

    @Override
    public Optional<String> getValue() {
        if (this.canonicalType.hasValue()) {
            return Optional.of(this.canonicalType.getValue());
        } else {
            return Optional.empty();
        }
    }
}
