/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import de.fhlintstone.accessors.IAccessorCache;
import lombok.EqualsAndHashCode;
import org.hl7.fhir.r4b.model.BackboneType;

/**
 * Implementation of {@link IBackboneTypeAccessor} for FHIR release R4B.
 */
@EqualsAndHashCode(callSuper = true)
public class BackboneTypeAccessorR4B extends TypeAccessorR4B implements IBackboneTypeAccessor {

    private final BackboneType type;

    /**
     * Creates a new wrapper.
     *
     * @param cache the cache this accessor is managed by
     * @param type the FHIR BackboneType to wrap
     */
    public BackboneTypeAccessorR4B(IAccessorCache cache, BackboneType type) {
        super(cache, type);
        this.type = type;
    }
}
