/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.model;

import de.fhlintstone.accessors.IAccessorCache;
import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.hl7.fhir.r4.model.BackboneElement;

/**
 * Implementation of {@link IBackboneElementAccessor} for FHIR release R4.
 */
@EqualsAndHashCode(callSuper = true)
public class BackboneElementAccessorR4 extends ElementAccessorR4 implements IBackboneElementAccessor {

    @Getter(AccessLevel.PRIVATE)
    private final BackboneElement element;

    /**
     * Creates a new wrapper.
     *
     * @param cache the cache this accessor is managed by
     * @param element the FHIR Base to wrap
     */
    public BackboneElementAccessorR4(IAccessorCache cache, BackboneElement element) {
        super(cache, element);
        this.element = element;
    }
}
