/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.dependencies;

import de.fhlintstone.fhir.dependencies.DependencyException;
import de.fhlintstone.fhir.dependencies.IDependencyCollector;
import org.hl7.fhir.instance.model.api.IBaseResource;

/**
 * Worker to visit a resource and determine its dependencies.
 */
public interface IDependencyResourceVisitor {

    /**
     * Visit a resource and determine its dependencies.
     *
     * @param resource  the {@link IBaseResource} to visit
     * @param collector the {@link IDependencyCollector} to send any dependencies to
     * @throws DependencyException when the dependencies could not be determined
     */
    void visit(IBaseResource resource, IDependencyCollector collector) throws DependencyException;
}
