/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors.dependencies;

import de.fhlintstone.accessors.implementations.IFrameworkTypeLocator;
import java.net.URISyntaxException;
import lombok.extern.slf4j.XSlf4j;

/**
 * Abstract superclass of all implementations of {@link IDependencyResourceVisitor}.
 */
@XSlf4j
abstract class DependencyResourceVisitor implements IDependencyResourceVisitor {

    protected IFrameworkTypeLocator frameworkTypeLocator;

    /**
     * Standard constructor
     * @param frameworkTypeLocator the {@link IFrameworkTypeLocator} to use
     */
    DependencyResourceVisitor(IFrameworkTypeLocator frameworkTypeLocator) {
        super();
        this.frameworkTypeLocator = frameworkTypeLocator;
    }

    protected String makeAbsoluteTypeReference(final String typeReference) throws URISyntaxException {
        return this.frameworkTypeLocator
                .makeAbsoluteStructureDefinitionReference(typeReference)
                .toString();
    }
}
