/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors;

/**
 * This exception signals an attempt to generate an accessor for an unsupported
 * object type or an attempt to convert an unsupported type to a string value.
 */
public class UnsupportedTypeException extends RuntimeException {

    private UnsupportedTypeException(String message) {
        super(message);
    }

    /**
     * Creates an exception signifying that an object type for which no accessor is
     * present is requested.
     *
     * @param object the unsupported object
     * @return the exception
     */
    public static UnsupportedTypeException forObjectType(Object object) {
        return new UnsupportedTypeException(String.format(
                "No accessor type for class %s available", object.getClass().getCanonicalName()));
    }

    /**
     * Creates an exception signifying that an object cannot be converted to a
     * string representation
     *
     * @param object the object that can not be converted to a string representation
     * @return the exception
     */
    public static UnsupportedTypeException forStringConversion(Object object) {
        return new UnsupportedTypeException(String.format(
                "An instance of class %s cannot be converted to a string representation",
                object.getClass().getCanonicalName()));
    }
}
