/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors;

/**
 * This exception signals that a URI cannot be resolved to a FHIR resource.
 */
public class UnresolvableURIException extends RuntimeException {

    /**
     * Constructor with text and nested exception.
     * @param message error text
     * @param cause nested exception
     */
    public UnresolvableURIException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructor with text only.
     * @param message error text
     */
    public UnresolvableURIException(String message) {
        super(message);
    }
}
