/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors;

/**
 * This exception signals an attempt to cast an accessor to an incompatible type.
 */
public class InvalidTypeException extends RuntimeException {

    /**
     * Default constructor.
     *
     * @param object the model object
     * @param targetType the requested accessor type
     */
    public InvalidTypeException(Object object, Class<? extends IAccessor> targetType) {
        super(String.format(
                "The accessor for class %s cannot be cast to %s",
                object.getClass().getCanonicalName(), targetType.getCanonicalName()));
    }
}
