/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors;

/**
 * Access to the accessor cache (which is also the accessor factory). This
 * interface is not intended to be used outside of the de.fhlintstone.accessors
 * package factory.
 */
public interface IAccessorCache {

    /**
     * Retrieves an existing accessor for a model object, or creates a new one. This
     * method performs a type check on the model object and always returns the most
     * specific accessor implementation available.
     *
     * @param modelObject the object to wrap
     * @throws UnsupportedTypeException if no accessor can be provided for the type
     * @return the accessor wrapping the model object
     */
    IAccessor getAccessor(Object modelObject);

    /**
     * Retrieves an existing accessor for a model object, or creates a new one. This
     * method performs an additional type check and is guaranteed to return an
     * accessor of the requested (or a more specific) type.
     *
     * @param <T>          the accessor type
     * @param modelObject  the object to wrap
     * @param accessorType the accessor type
     * @throws UnsupportedTypeException if no accessor can be provided for the type
     * @throws InvalidTypeException     if the accessor for the object can not be
     *                                  cast to the type requested
     * @return the accessor wrapping the model object
     */
    <T extends IAccessor> T getAccessor(Object modelObject, Class<T> accessorType);
}
